// Craig S. Kaplan
// A very explicit house drawing sketch that exposes
// (something like) the inner workings of geometric
// context, at least the translation part.  You don't
// actually need to write code like this -- with the
// geometric context functions (like translate()), 
// this stuff is all built-in.  But it's worth offering
// this demonstration.

void setup()
{
  size( 500, 500 );
}

float tx;
float ty;

void myRect( float x, float y, float w, float h )
{
  rect( x + tx, y + ty, w, h );
}

void myEllipse( float x, float y, float w, float h )
{
  ellipse( x + tx, y + ty, w, h );
}

void myTriangle( float x1, float y1, float x2, float y2, float x3, float y3 )
{
  triangle( x1 + tx, y1 + ty, 
    x2 + tx, y2 + ty,
    x3 + tx, y3 + ty );
}

void drawHouse()
{
  fill( #BFB375 );
  // Facade
  myRect( 150, 200, 200, 150 );
  // Chimney
  myRect( 320, 120, 30, 80 );
  
  fill( #3E362F );
  // Roof
  myTriangle( 250, 100, 120, 200, 370, 200 );
  
  fill( #DE584C );
  // Door
  myRect( 230, 280, 40, 70 );
  
  fill( #E8E8E8 );
  // Smoke
  myEllipse( 330, 100, 50, 20 );
  myEllipse( 350, 70, 40, 20 );
}

void draw()
{
  background( 255 );
  drawHouse();
}